% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAQILegend.R
\name{addAQILegend}
\alias{addAQILegend}
\title{Add an AQI legend to a map}
\usage{
addAQILegend(
  x = "topright",
  y = NULL,
  pollutant = c("PM2.5", "CO", "OZONE", "PM10", "AQI"),
  palette = c("EPA", "subdued", "deuteranopia"),
  languageCode = c("eng", "spa"),
  ...
)
}
\arguments{
\item{x}{x Coordinate passed on to the \code{legend()} command.}

\item{y}{y Coordinate passed on to the \code{legend()} command.}

\item{pollutant}{EPA AQS criteria pollutant.}

\item{palette}{Named color palette to use for AQI categories.}

\item{languageCode}{ISO 639-2 alpha-3 language code.}

\item{...}{Additional arguments to be passed to \code{legend()}.}
}
\value{
A list with components \code{rect} and \code{text} is returned
invisbly. (See \link{legend}.)
}
\description{
This function is a convenience wrapper around
\code{graphics::legend()}. It will show the AQI colors and
names by default if \code{col} and \code{legend} are not specified.

AQI categories are arranged with lower levels at the bottom of the legend
to match the arrangement in the plot. This is different from the default
"reading order" so you may wish to reverse the order of user supplied
arguments with \code{rev()} .
}
