% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_dailySoH.R
\name{pat_dailySoH}
\alias{pat_dailySoH}
\title{Daily state of health}
\usage{
pat_dailySoH(
  pat = NULL,
  SoH_functions = c("PurpleAirSoH_dailyPctDC", "PurpleAirSoH_dailyPctReporting",
    "PurpleAirSoH_dailyPctValid", "PurpleAirSoH_dailyOtherFit",
    "PurpleAirSoH_dailyABFit", "PurpleAirSoH_dailyABtTest")
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \code{pat} object.}

\item{SoH_functions}{Vector of function names. All the passed in functions 
must output tibbles with a daily \code{datetime} variable and must cover the same
period of time.}
}
\description{
This function combines the output of the State of Health (SoH) 
function arguments into a single tibble.
}
\examples{
\donttest{
library(AirSensor)

SoH <- 
  example_pat_failure_B \%>\%
  pat_dailySoH() 
  
timeseriesTbl_multiPlot(SoH, ncol = 4)
}
}
\seealso{
\link{pat_dailySoHPlot}
}
