% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.AlphaPart.R
\name{summary.AlphaPart}
\alias{summary.AlphaPart}
\title{summary.AlphaPart.R}
\usage{
\method{summary}{AlphaPart}(object, by = NULL, FUN = mean,
  labelSum = "Sum", subset = NULL, sums = FALSE, ...)
}
\arguments{
\item{object}{AlphaPart, output object from \code{\link[AlphaPart]{AlphaPart}} function.}

\item{by}{Character, the name of a column by which summary function FUN should
be applied; if \code{NULL} (default) summary is given for the whole table.}

\item{FUN}{Function, which function should be used in summary; function should
return single value per each level of by.}

\item{labelSum}{Character, label used for the overall additive genetic value.}

\item{subset}{Logical, perform summary only on a subset of \code{object} subsetted by
this argument.}

\item{sums}{Logical, link between \code{\link[AlphaPart]{AlphaPart}} and
\code{summary.AlphaPart()} (only for internal use!).}

\item{...}{Arguments passed to other functions (not used at the moment).}
}
\value{
An object of class \code{summaryAlphaPart}, which is a list of data frames
with summary statistics on additive genetic value partitions. For each trait there
is a list component holding two dataframes. The first data.frame is called \code{abs}
and holds summary for the "whole/original" additive genetic value and its partitions,
while the second data.frame is called \code{rel} and holds relative values of \code{abs}
counterpart. In addition another list is added (named \code{info}) with the following
components holdinfg meta info:
  \item{path}{column name holding path information}
  \item{nP}{number of paths}
  \item{lP}{path labels}
  \item{nT}{number of traits}
  \item{lT}{trait labels}
  \item{by}{column name of variable by which summary was performed}
  \item{warn}{potential warning messages associated with this object}
  \item{labelSum}{column name of summary for "whole/original" additive genetic values}

There is a handy plot method (\code{\link[AlphaPart]{plot.summaryAlphaPart}}) for output.
}
\description{
A function to summarize AlphaPart object.
}
\details{
Additive genetic values of individuals are often summarized, either by year of
birth or some other classification. Function \code{summary.AlphaPart} provides
a way to ease the computation of such summaries on partitions of additive
genetic values.
}
\examples{
## Load an example data
data("AlphaPart.ped")

## --- Partition additive genetic values by loc ---
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc", colAGV=c("agv1", "agv2")))

## Summarize whole population
(ret <- summary(res))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))

## --- Partition additive genetic values by loc and sex ---

AlphaPart.ped$loc.sex <- with(AlphaPart.ped, paste(loc, sex, sep="-"))
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc.sex", colAGV=c("agv1", "agv2")))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}} for partitioning additive genetic values,
\code{\link[AlphaPart]{plot.summaryAlphaPart}} for plotting output of summary method
}
