% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{meanP}
\alias{meanP}
\title{Mean phenotypic values}
\usage{
meanP(pop)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or \code{\link{HybridPop-class}}}
}
\description{
Returns the mean phenotypic values for all traits
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)
meanP(pop)

}
