% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{sampleHaplo}
\alias{sampleHaplo}
\title{Sample haplotypes from a MapPop}
\usage{
sampleHaplo(mapPop, nInd, inbred = FALSE, ploidy = NULL, replace = TRUE)
}
\arguments{
\item{mapPop}{the \code{\link{MapPop-class}} used to 
sample haplotypes}

\item{nInd}{the number of individuals to create}

\item{inbred}{should new individuals be fully inbred}

\item{ploidy}{new ploidy level for organism. If NULL, 
the ploidy level of the mapPop is used.}

\item{replace}{should haplotypes be sampled with replacement}
}
\value{
an object of \code{\link{MapPop-class}}
}
\description{
Creates a new \code{\link{MapPop-class}} from an existing 
\code{\link{MapPop-class}} by randomly sampling haplotypes.
}
\examples{
founderPop = quickHaplo(nInd=2,nChr=2,segSites=11,inbred=TRUE)
founderPop = sampleHaplo(mapPop=founderPop,nInd=20)

}
