% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r, R/hardwareSprites.r, R/iff.0.r,
%   R/iff.8svx.r, R/iff.ilbm.r, R/system_configuration.r, R/workbench_icon.r
\name{plot}
\alias{plot}
\alias{plot.AmigaBitmapFont}
\alias{plot}
\alias{plot.AmigaBitmapFontSet}
\alias{plot}
\alias{plot.hardwareSprite}
\alias{plot}
\alias{plot.IFFChunk}
\alias{plot}
\alias{plot.IFF.FORM}
\alias{plot}
\alias{plot.IFF.8SVX}
\alias{plot}
\alias{plot.IFF.ILBM}
\alias{plot}
\alias{plot.IFF.ANIM}
\alias{plot}
\alias{plot.SysConfig}
\alias{plot}
\alias{plot.AmigaIcon}
\title{Plot AmigaFFH objects}
\usage{
\method{plot}{AmigaBitmapFont}(x, y, ...)

\method{plot}{AmigaBitmapFontSet}(x, y, ...)

\method{plot}{hardwareSprite}(x, y, ...)

\method{plot}{IFFChunk}(x, y, ...)

\method{plot}{IFF.FORM}(x, y, ...)

\method{plot}{IFF.8SVX}(x, y, ...)

\method{plot}{IFF.ILBM}(x, y, ...)

\method{plot}{IFF.ANIM}(x, y, ...)

\method{plot}{SysConfig}(x, y, ...)

\method{plot}{AmigaIcon}(x, y, asp = 2, ...)
}
\arguments{
\item{x}{An AmigaFFH object to be plotted. See usage section for supported object
classes. If \code{x} is an \code{\link{AmigaBitmapFont}} or \code{\link{AmigaBitmapFontSet}}
class object, it will plot the full bitmap that is used to extract the font glyphs.}

\item{y}{When \code{x} is an \code{\link{AmigaIcon}} class object, \code{y} can be used as
an index. In that case, when \code{y=1} the first icon image is shown. When \code{y=2}
the selected icon image is shown.

When \code{x} is an \code{AmigaBitmapFontSet}
object, \code{y} can be used to plot the bitmap of a specific font height (\code{y}).}

\item{...}{Parameters passed onto the generic \code{graphics} plotting routine.

When \code{x} is an \code{\link{AmigaBitmapFont}} or an \code{\link{AmigaBitmapFontSet}}
object, '\code{...}' can also be used for arguments that need to be
passed onto the \code{\link[AmigaFFH]{as.raster}} function.}

\item{asp}{A \code{numeric} value indicating the aspect ratio for the plot. For
many AmigaFFH, the aspect ratio will be based on the Amiga display mode when known.
For \code{\link{AmigaIcon}} objects a default aspect ratio of \code{2} is used (tall
pixels).

When \code{x} is an \code{\link{AmigaBitmapFont}} or \code{\link{AmigaBitmapFontSet}} object,
an aspect ratio of 1 is used by default. When the \code{TALLDOT} flag
is set for that font, the aspect ratio s multiplied by 2. When the
\code{WIDEDOT} flag is set, it will be divided by 2.

A custom aspect ratio can also be used and will override the ratios specified above.}
}
\value{
Returns \code{NULL} silently.
}
\description{
Plot AmigaFFH objects using \code{base} plotting routines.
}
\details{
A plotting routine is implemented for most AmigaFFH objects. See the usage section
for all supported objects.
}
\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## and plot it:
plot(example.iff)

## AmigaIcons can also be plotted:
plot(simpleAmigaIcon())

## As can the cursor from a SysConfig object:
plot(simpleSysConfig())

## As can amiga fonts:
data(font_example)
plot(font_example)
plot(font_example, text = "foo bar", style = "underlined", interpolate = F)
}
}
\author{
Pepijn de Vries
}
