% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getNc}
\alias{getNc}
\title{Calculate the Effective Number of Codons}
\usage{
getNc(genome)
}
\arguments{
\item{genome}{A genome object initialized with \code{\link{initializeGenomeObject}}.}
}
\value{
Returns a named vector with the Effective Number of Codons for each gene
}
\description{
\code{getNc} returns the Effective Number of Codons for a genome.
}
\examples{

genome_file <- system.file("extdata", "more_genes.fasta", package = "AnaCoDa")
## reading genome
genome <- initializeGenomeObject(file = genome_file)

nc <- getNc(genome)

}
