% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcObject.R
\name{setRestartSettings}
\alias{setRestartSettings}
\title{Set Restart Settings}
\usage{
setRestartSettings(mcmc, filename, samples, write.multiple = TRUE)
}
\arguments{
\item{mcmc}{MCMC object that will run the model fitting algorithm.}

\item{filename}{Filename for the restart files to be written.}

\item{samples}{Number of samples that should occur before a file is written.}

\item{write.multiple}{Boolean that determines if multiple restart files
are written. Default value is TRUE.}
}
\value{
This function has no return value.
}
\description{
\code{setRestartSettings} sets the needed information (what the file 
is called, how often the file should be written) to write
information to restart the MCMC algorithm from a given point.
}
\details{
\code{setRestartSettings} writes a restart file every set amount of samples
that occur. Also, if write.multiple is true, instead of overwriting the previous restart
file, the sample number is prepended onto the file name and multiple rerstart files
are generated for a run.
}
\examples{

## set restart settings for checkpointing

samples <- 2500
thinning <- 50
adaptiveWidth <- 25

## estimate all parameter types
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
                             
# prompts the mcmc to write a restart file every 100 samples during the run.
setRestartSettings(mcmc = mcmc, filename = "test_restart", samples = 100)

# prompts the mcmc to write a restart file every 100 samples during the run, 
# but will overwrite it each time.
setRestartSettings(mcmc = mcmc, filename = "test_restart", samples = 100, 
                   write.multiple = FALSE)
           
}
