% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_mcmc.R
\name{AM_mcmc_refit}
\alias{AM_mcmc_refit}
\title{Performs a Gibbs sampling reusing previous configuration}
\usage{
AM_mcmc_refit(y, fit, fixed_clustering, mcmc_parameters = AM_mcmc_parameters())
}
\arguments{
\item{y}{input data, can be a vector or a matrix.}

\item{fit}{previous output from \code{\link{AM_mcmc_fit}} that is used to setup kernel and priors.}

\item{fixed_clustering}{is a vector CI of cluster assignment that will remain unchanged for every iterations.}

\item{mcmc_parameters}{is a configuration list defined by \code{\link{AM_mcmc_parameters}}.}
}
\value{
The return value is an \code{\link{AM_mcmc_output}} object.
}
\description{
Similar to \code{\link{AM_mcmc_fit}}, the \code{AM_mcmc_refit} function performs a Gibbs sampling in order to estimate
a mixture. However parameters will be reused from a previous result from \code{\link{AM_mcmc_fit}}.
}
\details{
In practice this function will call AM_mcmc_fit(y, fixed_clustering = fixed_clustering, ...); with the same parameters as previously
specified.
}
\examples{
\donttest{
 y = AM_sample_unipois()$y
 fit = AM_mcmc_fit( y , 
              AM_mix_hyperparams_unipois (alpha0=2, beta0=0.2), 
              mcmc_parameters = AM_mcmc_parameters(niter=20, burnin=0, thin=1, verbose=0))
 eam = AM_coclustering(fit)
 cluster = AM_salso(eam, "binder")
 refit = AM_mcmc_refit(y , fit, cluster, 
         mcmc_parameters = AM_mcmc_parameters(niter=20, burnin=0, thin=1, verbose=0));
}
}
