% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_functions.R
\name{avail_selection}
\alias{avail_selection}
\title{Available as selection candidates}
\usage{
avail_selection(gen, batch = 0, presel = 0, surv = NA, fish_per_FSfam = NA)
}
\arguments{
\item{gen}{The generation of the fish.}

\item{batch}{The batch of the fish. Default is 0. It is possible to provide a vector with multiple batches.}

\item{presel}{Identifies which preselected fish are available for selection. If no pre-selection took place, then presel should be 0 (= default).}

\item{surv}{Proportion of fish that is assumed to survive till the moment of selection. Either surv or fish_per_FSfam need to be provided.}

\item{fish_per_FSfam}{The number of fish available for selection per full sib family. Fish are randomly selected within a full sib family if fish_per_FSfam is specified. Either surv or fish_per_FSfam need to be provided.}
}
\value{
This function will make changes to the data frame called 'ped'. Fish that become available as selection candidates will be assigned a 1 to their column 'selcand'.
}
\description{
Function to determine which fish are available for selection. Fish are randomly chosen.
}
\examples{
\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselphen(gen = 1,
                  Nenv = 2,
                  Npresel = c(25,15),
                  trait = 1,
                  Ntraits = 2)
                  
ped <- avail_selection(gen = 1,
                       presel = 1,
                       surv = 0.9)
}
}
