% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspring_functions.R
\name{randommating}
\alias{randommating}
\title{Random mating family design}
\usage{
randommating(
  gen,
  batch = 0,
  batch_m = NA,
  batch_f = NA,
  Nfam_FS,
  No = NA,
  No_FSfam = NA,
  selected = 1
)
}
\arguments{
\item{gen}{The generations of the sires and dams.}

\item{batch}{The batch of the sires and dams. Default is 0.}

\item{batch_m}{The batch of the sires. Default is NA. If batch_m is specified, batch_f also needs to be specified and the parameter batch is not used.}

\item{batch_f}{The batch of the dams. Default is NA. If batch_f is specified, batch_m also needs to be specified and the parameter batch is not used.}

\item{Nfam_FS}{The number of full sib families.}

\item{No}{The total number of offspring of all matings. Default is NA.}

\item{No_FSfam}{The number of offspring in each full sib family. Default is NA.}

\item{selected}{The value in ped$selected of the selected sires and dams. Default is 1.}
}
\value{
The output is a data frame with for each full sib family the sire and dam and (optional) the number of offspring per full sib family.
}
\description{
Function to randomly allocate sires to dams.
}
\details{
A dataframe called ped needs to be present in the data. Ped needs to contain all the sires and dams that need to be allocated to each other and the columns sex, selected, generation, batch and id (first column).

The sires and dams can come from multiple batches or generations. In that case, a vector of batches or generations need to be provided.

Optionally, a column with the number of offspring per full sib family can be added to the dataframe. To do this, either the argument No_FSfam or No needs to be provided. In case No_FSfam is provided, each mating will have the same number of offspring (namely the value provided with No_FSfam). When No is provided, then the total number of offspring will be evenly divided among each mating if possible.
}
\examples{
{ ped <- founderpopfam(Nm=60,
                     Nf=60,
                     Nm2=0,
                     Nf2=0,
                     Ntraits=2,
                     TraitsIndex = 2,
                     Rgen= matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom= matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres= matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean=c(50,500),
                     a_var=c(200,8000),
                     c_var=c(150,1000),
                     e_var= c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)
}
}
