% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{averagebyday}
\alias{averagebyday}
\title{Average all the data collected on the same day.}
\usage{
averagebyday(x, newlabel)
}
\arguments{
\item{x}{an object of class \code{timeresolved}, \code{logratios},
\code{PHdata} or \code{redux}}

\item{newlabel}{a string with the new label that should be given to
the average}
}
\value{
an object of the same class as x
}
\description{
This function is useful for grouping a number of replicate air
shots or calibration experiments
}
\examples{
dfile <- system.file("Calibration.csv",package="ArArRedux")
dlabels <- c("H1","AX","L1","L2")
md <- loaddata(dfile,dlabels,PH=TRUE)
ld <- fitlogratios(blankcorr(md))
d <- averagebyday(ld,"DCAL")
plotcorr(d)
}

