% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MarginalStatistics}
\alias{MarginalStatistics}
\title{Marginal summary statistics}
\usage{
MarginalStatistics(a_chain, level = 0.95)
}
\arguments{
\item{a_chain}{numeric vector containing the output of the MCMC algorithm for a one-parameter. The MCMC samples should be in calendar year (BC/AD). }

\item{level}{probability corresponding to the level of confidence used for the credible interval and the highest density region}
}
\value{
A matrix of values corresponding to the following summary statistics
  \item{title }{The title of the summary statistics}
  \item{mean }{The mean of the MCMC chain. Use of "mean" function.}
  \item{map }{The maximum a posteriori of the MCMC chain. Use of "hdr" function.}
  \item{sd }{The standard deviation of the MCMC chain. Use of "sd" function. }
  \item{Q1, median, Q3 }{The quantiles of the MCMC chain corresponding to 0.25, 0.50 and 0.75. Use of "quantile" function.}
  \item{CI }{The credible interval corresponding to the desired level. Use of "CredibleInterval" function.}
  \item{HPDR }{The highest posterior density regions corresponding to the desired level. Use of "hdr" function.}
  The results are given in calendar year (in format BC/AD).
}
\description{
Gives a list of summary statistics resulting from the output of the MCMC algorithm for a one-parameter. Results are given in calendar year (BC/AD).
}
\details{
The 100*level \% HPD (highest posterior density) region is estimated using HDR function from Package 'hdrcde'.
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density regions. American Statistician, 50, 120-126.

}
\examples{

  data(Events); attach(Events)
  
  MarginalStatistics(Event.1)
  MarginalStatistics(Event.2, level = 0.90)
  
}

\keyword{ summary statistics}
\keyword{ credible interval}
\keyword{ maximum a posteriori}
\keyword{ mean}
\keyword{ highest posterior density}
