% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhasesGap.R
\name{PhasesGap}
\alias{PhasesGap}
\title{Gap or hiatus between two successive phases (for phases in temporal order constraint)}
\usage{
PhasesGap(Phase1Max_chain, Phase2Min_chain, level = 0.95)
}
\arguments{
\item{Phase1Max_chain}{Numeric vector containing the output of the MCMC
algorithm for the maximum of the events included in the oldest phase.}

\item{Phase2Min_chain}{Numeric vector containing the output of the MCMC
algorithm for the minimum of the events included in the following phase.}

\item{level}{Probability corresponding to the level of confidence.}
}
\value{
Returns a vector of values containing the level of confidence and
the endpoints of the gap between the successive phases. The result is
given in calendar years (BC/AD).
}
\description{
This function finds, if it exists, a gap or hiatus between two successive phases.
This gap or hiatus is the longest interval that satisfies
\eqn{P(Phase1Max_chain < IntervalInf < IntervalSup < Phase2Min_chain | M) = level}
}
\examples{
  data(Phases); attach(Phases)
  PhasesGap(Phase.1.beta, Phase.2.alpha, 0.95)
  PhasesGap(Phase.1.beta, Phase.2.alpha, 0.50)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
