% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{expand_column}
\alias{expand_column}
\title{Expand information of columns in JSON format}
\usage{
expand_column(query, column_name)
}
\arguments{
\item{query}{The query object with a JSON formatted column to be expanded.}

\item{column_name}{(character) The name of the column to be expanded.}
}
\value{
Nothing.
}
\description{
Expand all information contained in a JSON formatted column in a query
object. Information is presented as nested data frames if needed.
}
\examples{
library(ArctosR)

# Request to download all available data
response <- get_records(
  scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
  columns = list("guid", "parts", "partdetail")
)

# The partdetail column is a JSON list of parts and their attributes
# This will convert the column to dataframes:
expand_column(response, "partdetail")

}
