% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{plot_predicted_risk}
\alias{plot_predicted_risk}
\title{AutoScore function for binary and ordinal outcomes: Plot predicted risk}
\usage{
plot_predicted_risk(
  pred_score,
  link = "logit",
  max_score = 100,
  final_variables,
  scoring_table,
  point_size = 0.5
)
}
\arguments{
\item{pred_score}{Output from \code{\link{AutoScore_testing}} (for binary
outcomes) or \code{\link{AutoScore_testing_Ordinal}} (for ordinal
outcomes).}

\item{link}{(For ordinal outcome only) The link function used in ordinal
regression, which must be the same as the value used to build the risk
score. Default is \code{"logit"} for proportional odds model.}

\item{max_score}{Maximum total score (Default: 100).}

\item{final_variables}{A vector containing the list of selected variables,
selected from Step(ii) \code{\link{AutoScore_parsimony}} (for binary
outcomes) or \code{\link{AutoScore_parsimony_Ordinal}} (for ordinal
outcomes).}

\item{scoring_table}{The final scoring table after fine-tuning, generated
from STEP(iv) \code{\link{AutoScore_fine_tuning}} (for binary outcomes) or
\code{\link{AutoScore_fine_tuning_Ordinal}} (for ordinal outcomes).}

\item{point_size}{Size of points in the plot. Default is 0.5.}
}
\description{
AutoScore function for binary and ordinal outcomes: Plot predicted risk
}
