% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_format_utils.R
\name{storage_save_rds}
\alias{storage_save_rds}
\alias{storage_load_rds}
\alias{storage_save_rdata}
\alias{storage_load_rdata}
\title{Save and load R objects to/from a storage account}
\usage{
storage_save_rds(object, container, file, ...)

storage_load_rds(container, file, ...)

storage_save_rdata(..., container, file, envir = parent.frame())

storage_load_rdata(container, file, envir = parent.frame(), ...)
}
\arguments{
\item{object}{An R object to save to storage.}

\item{container}{An Azure storage container object.}

\item{file}{The name of a file in storage.}

\item{...}{Further arguments passed to \code{serialize}, \code{unserialize}, \code{save} and \code{load} as appropriate.}

\item{envir}{For \code{storage_save_rdata} and \code{storage_load_rdata}, the environment from which to get objects to save, or in which to restore objects, respectively.}
}
\description{
Save and load R objects to/from a storage account
}
\details{
These are equivalents to \code{saveRDS}, \code{readRDS}, \code{save} and \code{load} for saving and loading R objects to a storage account. With the exception of \code{storage_save_rdata}, they work via connections and so do not create temporary files. \code{storage_save_rdata} uses a temporary file so that compression of the resulting image is enabled.
}
\examples{
\dontrun{

bl <- storage_endpoint("https://mystorage.blob.core.windows.net/", key="access_key")
cont <- storage_container(bl, "mycontainer")

storage_save_rds(iris, cont, "iris.rds")
irisnew <- storage_load_rds(iris, "iris.rds")
identical(iris, irisnew)  # TRUE

storage_save_rdata(iris, mtcars, container=cont, file="dataframes.rdata")
storage_load_rdata(cont, "dataframes.rdata")

}
}
\seealso{
\link{storage_download}, \link{download_blob}, \link{download_azure_file}, \link{download_adls_file}, \link{save}, \link{load}, \link{saveRDS}
}
