% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmss_config.R
\name{vmss_config}
\alias{vmss_config}
\alias{ubuntu_dsvm_ss}
\alias{windows_dsvm_ss}
\alias{ubuntu_16.04_ss}
\alias{ubuntu_18.04_ss}
\alias{windows_2016_ss}
\alias{windows_2019_ss}
\alias{rhel_7.6_ss}
\alias{rhel_8_ss}
\alias{centos_7.5_ss}
\alias{centos_7.6_ss}
\alias{debian_8_backports_ss}
\alias{debian_9_backports_ss}
\title{Virtual machine scaleset configuration functions}
\usage{
vmss_config(image, options = scaleset_options(), nsg = nsg_config(),
  vnet = vnet_config(), load_balancer = lb_config(),
  load_balancer_address = ip_config(),
  autoscaler = autoscaler_config(), other_resources = list(),
  variables = list(), ...)

ubuntu_dsvm_ss(nsg = nsg_config(list(nsg_rule_allow_ssh,
  nsg_rule_allow_jupyter, nsg_rule_allow_rstudio)),
  load_balancer = lb_config(rules = list(lb_rule_ssh, lb_rule_jupyter,
  lb_rule_rstudio), probes = list(lb_probe_ssh, lb_probe_jupyter,
  lb_probe_rstudio)), ...)

windows_dsvm_ss(nsg = nsg_config(list(nsg_rule_allow_rdp)),
  load_balancer = lb_config(rules = list(lb_rule_rdp), probes =
  list(lb_probe_rdp)), options = scaleset_options(keylogin = FALSE), ...)

ubuntu_16.04_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

ubuntu_18.04_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

windows_2016_ss(nsg = nsg_config(list(nsg_rule_allow_rdp)),
  load_balancer = lb_config(rules = list(lb_rule_rdp), probes =
  list(lb_probe_rdp)), options = scaleset_options(keylogin = FALSE), ...)

windows_2019_ss(nsg = nsg_config(list(nsg_rule_allow_rdp)),
  load_balancer = lb_config(rules = list(lb_rule_rdp), probes =
  list(lb_probe_rdp)), options = scaleset_options(keylogin = FALSE), ...)

rhel_7.6_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

rhel_8_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

centos_7.5_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

centos_7.6_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

debian_8_backports_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)

debian_9_backports_ss(nsg = nsg_config(list(nsg_rule_allow_ssh)),
  load_balancer = lb_config(rules = list(lb_rule_ssh), probes =
  list(lb_probe_ssh)), ...)
}
\arguments{
\item{image}{For \code{vmss_config}, the VM image to deploy. This should be an object of class \code{image_config}, created by the function of the same name.}

\item{options}{Scaleset options, as obtained via a call to \code{scaleset_options}.}

\item{nsg}{The network security group for the scaleset. Can be a call to \code{nsg_config} to create a new NSG; an AzureRMR resource object or resource ID to reuse an existing NSG; or NULL to not use an NSG (not recommended).}

\item{vnet}{The virtual network for the scaleset. Can be a call to \code{vnet_config} to create a new virtual network, or an AzureRMR resource object or resource ID to reuse an existing virtual network. Note that by default, AzureVM will associate the NSG with the virtual network/subnet, not with the VM's network interface.}

\item{load_balancer}{The load balancer for the scaleset. Can be a call to \code{lb_config} to create a new load balancer;  an AzureRMR resource object or resource ID to reuse an existing load balancer; or NULL if load balancing is not required.}

\item{load_balancer_address}{The public IP address for the load balancer. Can be a call to \code{ip_config} to create a new IP address, or an AzureRMR resource object or resource ID to reuse an existing address resource. Ignored if \code{load_balancer} is NULL.}

\item{autoscaler}{The autoscaler for the scaleset. Can be a call to \code{autoscaler_config} to create a new autoscaler; an AzureRMR resource object or resource ID to reuse an existing autoscaler; or NULL if autoscaling is not required.}

\item{other_resources}{An optional list of other resources to include in the deployment.}

\item{variables}{An optional named list of variables to add to the template.}

\item{...}{For the specific VM configurations, other customisation arguments to be passed to \code{vm_config}. For \code{vmss_config}, named arguments that will be folded into the scaleset resource definition in the template.}
}
\value{
An object of S3 class \code{vmss_config}, that can be used by the \code{create_vm_scaleset} method.
}
\description{
Virtual machine scaleset configuration functions
}
\details{
These functions are for specifying the details of a new virtual machine scaleset deployment: the base VM image and related options, along with the Azure resources that the scaleset may need. These include the network security group, virtual network, load balancer and associated public IP address, and autoscaler.

Each resource can be specified in a number of ways:
\itemize{
\item To \emph{create} a new resource as part of the deployment, call the corresponding \code{*_config} function.
\item To use an \emph{existing} resource, supply either an \code{AzureRMR::az_resource} object (recommended) or a string containing the resource ID.
\item If the resource is not needed, specify it as NULL.
\item For the \code{other_resources} argument, supply a list of resources, each of which should be a list of resource fields (name, type, properties, sku, etc).
}

The \code{vmss_config} function is the base configuration function, and the others call it to create VM scalesets with specific operating systems and other image details.
\itemize{
\item \code{ubuntu_dsvm_ss}: Data Science Virtual Machine, based on Ubuntu 16.04
\item \code{windows_dsvm_ss}: Data Science Virtual Machine, based on Windows Server 2016
\item \code{ubuntu_16.04_ss}, \code{ubuntu_18.04}: Ubuntu LTS
\item \code{windows_2016_ss}, \code{windows_2019}: Windows Server Datacenter edition
\item \code{rhel_7.6_ss}, \code{rhel_8_ss}: Red Hat Enterprise Linux
\item \code{centos_7.5_ss}, \code{centos_7.6_ss}: CentOS
\item \code{debian_8_backports_ss}, \code{debian_9_backports_ss}: Debian with backports
}

A VM scaleset configuration defines the following template variables by default, depending on its resources. If a particular resource is created, the corresponding \code{*Name}, \code{*Id} and \code{*Ref} variables will be available. If a resource is referred to but not created, the \code{*Name*} and \code{*Id} variables will be available. Other variables can be defined via the \code{variables} argument.

\tabular{lll}{
\strong{Variable name} \tab \strong{Contents} \tab \strong{Description} \cr
\code{location} \tab \code{[resourceGroup().location]} \tab Region to deploy resources \cr
\code{vmId} \tab \code{[resourceId('Microsoft.Compute/virtualMachines', parameters('vmName'))]} \tab VM scaleset resource ID \cr
\code{vmRef} \tab \code{[concat('Microsoft.Compute/virtualMachines/', parameters('vmName'))]} \tab Scaleset template reference \cr
\code{nsgName} \tab \code{[concat(parameters('vmName'), '-nsg')]} \tab Network security group resource name \cr
\code{nsgId} \tab \code{[resourceId('Microsoft.Network/networkSecurityGroups', variables('nsgName'))]} \tab NSG resource ID \cr
\code{nsgRef} \tab \code{[concat('Microsoft.Network/networkSecurityGroups/', variables('nsgName'))]} \tab NSG template reference \cr
\code{vnetName} \tab \code{[concat(parameters('vmName'), '-vnet')]} \tab Virtual network resource name \cr
\code{vnetId} \tab \code{[resourceId('Microsoft.Network/virtualNetworks', variables('vnetName'))]} \tab Vnet resource ID \cr
\code{vnetRef} \tab \code{[concat('Microsoft.Network/virtualNetworks/', variables('vnetName'))]} \tab Vnet template reference \cr
\code{subnet} \tab \code{subnet} \tab Subnet name. Only defined if a Vnet was created or supplied as an \code{az_resource} object. \cr
\code{subnetId} \tab \code{[concat(variables('vnetId'), '/subnets/', variables('subnet'))]} \tab Subnet resource ID. Only defined if a Vnet was created or supplied as an \code{az_resource} object. \cr
\code{lbName} \tab \code{[concat(parameters('vmName'), '-lb')]} \tab Load balancer resource name \cr
\code{lbId} \tab \code{[resourceId('Microsoft.Network/loadBalancers', variables('lbName'))]} \tab Load balancer resource ID \cr
\code{lbRef} \tab \code{[concat('Microsoft.Network/loadBalancers/', variables('lbName'))]} \tab Load balancer template reference \cr
\code{lbFrontendName} \tab \code{frontend} \tab Load balancer frontend IP configuration name. Only defined if a load balancer was created or supplied as an \code{az_resource} object. \cr
\code{lbBackendName} \tab \code{backend} \tab Load balancer backend address pool name. Only defined if a load balancer was created or supplied as an \code{az_resource} object. \cr
\code{lbFrontendId} \tab \code{[concat(variables('lbId'), '/frontendIPConfigurations/', variables('lbFrontendName'))]} \tab Load balancer frontend resource ID. Only defined if a load balancer was created or supplied as an \code{az_resource} object. \cr
\code{lbBackendId} \tab \code{[concat(variables('lbId'), '/backendAddressPools/', variables('lbBackendName'))]} \tab Load balancer backend resource ID. Only defined if a load balancer was created or supplied as an \code{az_resource} object. \cr
\code{ipName} \tab \code{[concat(parameters('vmName'), '-ip')]} \tab Public IP address resource name \cr
\code{ipId} \tab \code{[resourceId('Microsoft.Network/publicIPAddresses', variables('ipName'))]} \tab IP resource ID \cr
\code{ipRef} \tab \code{[concat('Microsoft.Network/publicIPAddresses/', variables('ipName'))]} \tab IP template reference \cr
\code{asName} \tab \code{[concat(parameters('vmName'), '-as')]} \tab Autoscaler resource name \cr
\code{asId} \tab \code{[resourceId('Microsoft.Insights/autoscaleSettings', variables('asName'))]} \tab Autoscaler resource ID \cr
\code{asRef} \tab \code{[concat('Microsoft.Insights/autoscaleSettings/', variables('asName'))]} \tab Autoscaler template reference \cr
\code{asMaxCapacity} \tab \code{[mul(int(parameters('instanceCount')), 10)]} \tab Maximum capacity for the autoscaler. Only defined if an autoscaler was created. \cr
\code{asScaleValue} \tab \code{[max(div(int(parameters('instanceCount')), 5), 1)]} \tab Default capacity for the autoscaler. Only defined if an autoscaler was created.
}

Thus, for example, if you are creating a VM scaleset named "myvmss" along with all its associated resources, the NSG is named "myvmss-nsg", the virtual network is "myvmss-vnet", the load balancer is "myvmss-lb", the public IP address is "myvmss-ip", and the autoscaler is "myvm-as".
}
\examples{

# basic Linux (Ubuntu) and Windows configs
ubuntu_18.04_ss()
windows_2019_ss()

# Windows DSVM scaleset, no load balancer and autoscaler
windows_dsvm_ss(load_balancer=NULL, autoscaler=NULL)

# RHEL VM exposing ports 80 (HTTP) and 443 (HTTPS)
rhel_8_ss(nsg=nsg_config(nsg_rule_allow_http, nsg_rule_allow_https))

# exposing no ports externally
rhel_8_ss(nsg=nsg_config(list()))

# low-priority VMs, large scaleset (>100 instances allowed), no managed identity
rhel_8_ss(options=scaleset_options(low_priority=TRUE, large_scaleset=TRUE, managed=FALSE))


\dontrun{

# reusing existing resources: placing a scaleset in an existing vnet/subnet
# we don't need a new network security group either
vnet <- AzureRMR::get_azure_login()$
    get_subscription("sub_id")$
    get_resource_group("rgname")$
    get_resource(type="Microsoft.Network/virtualNetworks", name="myvnet")

ubuntu_18.04_ss(vnet=vnet, nsg=NULL)

}
}
\seealso{
\link{scaleset_options} for options relating to the scaleset resource itself

\link{nsg_config}, \link{ip_config}, \link{vnet_config}, \link{lb_config}, \link{autoscaler_config} for other resource configs

\link{build_template} for template builder methods

\link{vm_config} for configuring an individual virtual machine

\link{create_vm_scaleset}
}
