% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_imgs.R
\name{browse_images}
\alias{browse_images}
\title{View images uploaded to a Custom Vision project}
\usage{
browse_images(project, img_ids, which = c("resized", "original",
  "thumbnail"), max_images = 20, iteration = NULL)
}
\arguments{
\item{project}{A Custom Vision project.}

\item{img_ids}{The IDs of the images to view. You can use \code{\link{list_images}} to get the image IDs for this project.}

\item{which}{Which image to view: the resized version used for training (the default), the original uploaded image, or the thumbnail.}

\item{max_images}{The maximum number of images to display.}

\item{iteration}{The iteration ID (roughly, which model generation to use). Defaults to the latest iteration.}
}
\description{
View images uploaded to a Custom Vision project
}
\details{
Images in a Custom Vision project are stored in Azure Storage. This function gets the URLs for the uploaded images and displays them in your browser.
}
\seealso{
\code{\link{list_images}}
}
