% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_scraping.R
\name{get_events}
\alias{get_events}
\title{Scrape the number of advertised events in Bath for each day}
\usage{
get_events(from, to)
}
\arguments{
\item{from}{A date or date-time object, or YYYY-MM-DD string: the first day
from which to get an event count.}

\item{to}{A date or date-time object, or YYYY-MM-DD string: the last day
from which to get an event count.}
}
\value{
A data frame of daily event counts for each day in the specified
 range.
}
\description{
Web scraping function to retrieve the number of events advertised at
 \url{http://www.bath.co.uk/events} for each day in a specified range of
 months.\cr\cr
 \emph{Note: Have a look at this package's GitHub repo - in particular,
  \href{https://github.com/owenjonesuob/BANEScarparking/blob/master/R/web_scraping.R}{here}
  - to see the code for this function, along with comments which
  explain the process followed. See \code{\link{get_rugby}} for a similar
  function with more detailed commentary!}
}
\examples{
# Return event count for 01 January 2015
events <- get_events("2015-01-01", "2015-01-01")
\donttest{
# Return daily event counts from 01 Oct 2014 to 17 Jul 2015
events <- get_events("2014-10-01", "2015-07-17")

# Return daily event counts for all months in date range of parking records
raw_data <- get_all_crude()
df <- refine(raw_data)

events <- get_events(min(df$LastUpdate), max(df$LastUpdate))
}
}
\seealso{
\code{\link{get_events_detail}}
}
