% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updates.R
\name{update_w_beta}
\alias{update_w_beta}
\title{update_w_beta}
\usage{
update_w_beta(S, E, hyper_delta = 1)
}
\arguments{
\item{S}{The number of patient level clusters}

\item{E}{A vector that records the current clustering membership.}

\item{hyper_delta}{The hyper-parameter with default value being 1}
}
\value{
The updated weights for each patient level cluster
}
\description{
This function updates the weights for each patient level cluster
}
\examples{
#Suppose we know the number of patient level cluster is 4
#Suppose the current clustering membership indicates 3 patients in cluster 1,
#2 patients in cluster 2, 3 patinets in cluster 3, 1 patient in cluster 4
#Use the default value, 1, for hyper-parameter
update_w_beta(S=4,E=c(1,1,1,2,2,3,3,3,4))


#To change the hyper-parameter to, for example 2
update_w_beta(S=4,E=c(1,1,1,2,2,3,3,3,4),hyper_delta = 2)
}
\seealso{
\link{update_RJ} for a complete example for all functions in this package.
}
