% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.beta.evenness}
\alias{kernel.beta.evenness}
\title{Functional beta diversity evenness using kernel density hypervolumes.}
\usage{
kernel.beta.evenness(comm)
}
\arguments{
\item{comm}{A 'HypervolumesList' object, preferably built using function kernel.build.}
}
\value{
Distance matrix between sites.
}
\description{
Difference of evenness between pairs of sites, measuring the regularity of stochastic points distribution within the total functional space.
}
\details{
This measure is simply the pairwise difference of evenness calculated based on the functional evenness (Mason et al., 2005) of a n-dimensional hypervolume, namely the regularity of stochastic points distribution within the total trait space (Mammola & Cardoso, 2020).
Evenness is calculated as the overlap between the observed hypervolume and a theoretical hypervolume where traits and abundances are evenly distributed within the range of their values (Carmona et al., 2016, 2019).
}
\examples{
\dontrun{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
colnames(comm) = c("SpA","SpB","SpC","SpD", "SpE")
rownames(comm) = c("Site 1","Site 2","Site 3","Site 4")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4),c(0.7,1.2,0.5,0.4,5),c(0.7,2.2,0.5,0.3,6))
colnames(trait) = c("Trait 1","Trait 2","Trait 3","Trait 4")
rownames(trait) = colnames(comm)

hvlist = kernel.build(comm, trait)
kernel.beta.evenness(hvlist)
hvlist = kernel.build(comm, trait, axes = 0.9)
kernel.beta.evenness(hvlist)
}
}
\references{
Carmona, C.P., de Bello, F., Mason, N.W.H. & Leps, J. (2016) Traits without borders: integrating functional diversity across scales. Trends in Ecology and Evolution, 31: 382-394.

Carmona, C.P., de Bello, F., Mason, N.W.H. & Leps, J. (2019) Trait probability density (TPD): measuring functional diversity across scales based on TPD with R. Ecology, 100: e02876.

Mason, N.W.H., Mouillot, D., Lee, W.G. & Wilson, J.B. (2005) Functional richness, functional evenness and functional divergence: the primary components of functional diversity. Oikos, 111: 112-118.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.
}
