% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.evenness}
\alias{kernel.evenness}
\title{Functional evenness of kernel density hypervolumes.}
\usage{
kernel.evenness(comm)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumesList' object, preferably built using function kernel.build.}
}
\value{
A value or vector of evenness values for each site.
}
\description{
Functional evenness of a community, measuring the regularity of stochastic points distribution within the total functional space.
}
\details{
This function measures the functional evenness (Mason et al., 2005) of a n-dimensional hypervolume, namely the regularity of stochastic points distribution within the total trait space (Mammola & Cardoso, 2020).
Evenness is calculated as the overlap between the observed hypervolume and a theoretical hypervolume where traits and abundances are evenly distributed within the range of their values (Carmona et al., 2016, 2019).
}
\examples{
\dontrun{
comm = rbind(c(100,3,0,5,3), c(3,2,5,1,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
kernel.evenness(hv)
hv = kernel.build(comm[1,], trait, abund = FALSE)
kernel.evenness(hv)
hvlist = kernel.build(comm, trait, axes = 2)
kernel.evenness(hvlist)
}
}
\references{
Carmona, C.P., de Bello, F., Mason, N.W.H. & Leps, J. (2016) Traits without borders: integrating functional diversity across scales. Trends in Ecology and Evolution, 31: 382-394.

Carmona, C.P., de Bello, F., Mason, N.W.H. & Leps, J. (2019) Trait probability density (TPD): measuring functional diversity across scales based on TPD with R. Ecology, 100: e02876.

Mason, N.W.H., Mouillot, D., Lee, W.G. & Wilson, J.B. (2005) Functional richness, functional evenness and functional divergence: the primary components of functional diversity. Oikos, 111: 112-118.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.
}
