% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_process_acb_pbp.R
\name{do_process_acb_pbp}
\alias{do_process_acb_pbp}
\title{Processing of the ACB website play-by-play data}
\usage{
do_process_acb_pbp(game_elem, day, game_code, period, acb_shields, verbose)
}
\arguments{
\item{game_elem}{Character with the tangled play-by-play data.}

\item{day}{Day of the game.}

\item{game_code}{Game code.}

\item{period}{Period of the game.}

\item{acb_shields}{Data frame with the links to the shields of the ACB teams.}

\item{verbose}{Logical to display processing information.}
}
\value{
Data frame with eight columns: 
\itemize{
\item period: Period of the game.
\item time_point: Time point when the basketball action happens.
\item player: Player who performs the action.
\item action: Basketball action.
\item local_score: Local score at that time point.
\item visitor_score: Visitor score at that time point.
\item day: Day of the game.
\item game_code: Game code.
}
}
\description{
This function disentangles the play-by-play data coming from the ACB website and 
creates a common data structure in R.
}
\note{
1. Actions are given in Spanish. A bilingual basketball vocabulary (Spanish/English)
is provided in \url{https://www.uv.es/vivigui/docs/basketball_dictionary.xlsx}.

2. The \strong{game_code} column allows us to detect the source website, for example,
\url{https://jv.acb.com/es/103389/jugadas}.
}
\examples{
\dontrun{
# Load packages required:
library(RSelenium)

# Provide the day and game code:
day <- "24"
game_code <- "103170"

# Open an Internet server:
rD <- rsDriver(browser = "firefox", chromever = NULL)

# Follow this procedure on the server:
# 1. Copy and paste the game link https://jv.acb.com/es/103170/jugadas
# 2. Click on each period, starting with 1C.
# 3. Scroll down to the first row of data.
# 4. Go back to R and run the following code:
 
# Set the remote driver:
remDr <- rD$client

# Get the play-by-play data:
game_elem <- remDr$getPageSource()[[1]]

# Close the client and the server:
remDr$close()
rD$server$stop()

period <- "1C"
data_game <- do_process_acb_pbp(game_elem, day, game_code, 
                                period, acb_shields, FALSE)
}

}
\author{
Guillermo Vinue
}
