% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_counts}
\alias{compute_counts}
\title{Compute empirical frequencies of all contexts}
\usage{
compute_counts(input_data, depth)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section of the BCT/kBCT functions on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}
}
\value{
a list containing the counts of all contexts of length \ifelse{html}{\out{&le;}}{\eqn{\le}} depth. 
If a context with a smaller length than the maximum depth is not contained in the output, its associated count vector is 0. 'Root' indicates the empty context.
}
\description{
Computes the count vectors of all contexts up to a certain length (D) for a given dataset. The first D characters are used to construct the initial context and the counting is performed on the remaining characters.
These counts are needed for intermediate computations in BCT and kBCT, 
and can also be viewed as maximum likelihood estimates of associated parameters; see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.
}
\examples{
# For the pewee dataset:
compute_counts(pewee, 3)
}
\seealso{
\code{\link{BCT}}, \code{\link{generate_data}}
}
