\name{BEAST}
\alias{BEAST}
\title{Binary Expansion Adaptive Symmetry Test}
\usage{
BEAST(
  X,
  dep,
  subsample.percent = 1/2,
  B = 100,
  unif.margin = FALSE,
  lambda = NULL,
  index = list(c(1:ncol(X))),
  method = "p",
  num = NULL
)
}
\arguments{
\item{X}{a matrix to be tested.}

\item{dep}{depth of the binary expansion for the \code{BEAST}.}

\item{subsample.percent}{sample size for subsampling.}

\item{B}{times of subsampling.}

\item{unif.margin}{logicals. If \code{TRUE} the marginal distribution is known to be Uniform[0,1]. Default is \code{FALSE}, and empirical cdf transformation will be applied to each marginal distribution.}

\item{lambda}{tuning parameter for soft-thresholding, default to be \eqn{sqrt(log(2^(p * dep)) / (8*n))}.}

\item{index}{
  a list of indices. If provided, test the independence among two or more groups of variables. For example, \code{index = list(c(1,2), c(3)))} refers to test the independence between \eqn{(X_1, X_2)} and \eqn{X_3}. Default to be \code{list(c(1:p))} to test if the data follow the uniform distribution over [0,1]^p, where \code{p = ncol(X)}.
}
\item{method}{
  If \code{"p"}, then compute null distribution with permutations. If \code{"s"}, then compute null distribution with simulations. If \code{"stat"}, only return interaction and BEAST Statistic.
}
\item{num}{
  number of permutations if method == "p" (default to be 100), or simulations if method == "s" (default to be 1000).
}
}

\value{
\item{Interaction}{the most frequent interaction among all subsamples.}
\item{BEAST.Statistic}{BEAST statistic.}
\item{Null.Distribution}{simulated null distribution.}
\item{p.value}{simulated p-value.}
}

\description{
\code{BEAST} (Binary Expansion Adaptive Symmetry Test) is used for nonparametric detection of nonuniformity or dependence.
}
\examples{
## Elapsed times 7.73 secs
## Measured in R 4.0.2, 32 bit, on a processor 3.3 GHz 6-Core Intel Core i5 under MacOS, 2021/9/8
\dontrun{
x1 = runif(128)
x2 = runif(128)
y = sin(4*pi*(x1 + x2)) + 0.8*rnorm(128)
##test independence between (x1, x2) and y
BEAST(cbind(x1, x2, y), 3, index = list(c(1,2), c(3)))
##test mutual independence among x1, x2 and y
BEAST(cbind(x1, x2, y), 3, index = list(c(1), c(2), c(3)))

##test uniformity
x1 = rbeta(128, 2, 4)
x2 = rbeta(128, 2, 4)
x3 = rbeta(128, 2, 4)
BEAST(cbind(x1, x2, x3), 3)

##with a known simulation
BEAST.null <- BEAST.null.simu(128, 3, 3,index = list(c(1,2), c(3)))
x1 = runif(128)
x2 = runif(128)
y = sin(4*pi*(x1 + x2)) + 0.8*rnorm(128)
BEAST.stat = BEAST(cbind(x1, x2, y), 3, index = list(c(1,2), c(3)),
    method = "stat")$BEAST.Statistic
mean(BEAST.stat<BEAST.null)  # p-value
}
}
