% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_get_base_maps.R
\name{bfs_get_base_maps}
\alias{bfs_get_base_maps}
\title{Get Switzerland base maps data}
\usage{
bfs_get_base_maps(
  geom = NULL,
  category = "gf",
  type = "Poly",
  date = NULL,
  most_recent = TRUE,
  format = "shp",
  asset_number = "24025646"
)
}
\arguments{
\item{geom}{Geometry such as "suis", "kant", "bezk", "polg", "voge", etc.}

\item{category}{Category such as 'total_area' ("gf" for "Gesamtflaeche") or 
'vegetation_area' ("vf" for "Vegetationsflaeche").}

\item{type}{The type of data, i.e. "Poly" or "Pnts".}

\item{date}{Date (yyyymmdd) of reference / validity. If not specified, the
`most_recent` argument is used.}

\item{most_recent}{Get the most recent by sorting the files in decreasing order,
if FALSE then read the first file available.}

\item{format}{Format of the file, by default SHP format.}

\item{asset_number}{Asset number of the base maps zip file.}
}
\description{
This functions helps to get base maps data from the ThemaKart project
as an sf object. The geom names and the general structure of the files
can be found in the offical BFS documentation, 
see \url{https://www.bfs.admin.ch/asset/en/24025645}. When using this data, please read the condition of use
and copyright mentions.
}
\details{
If you want to get ThemaKart data from previous years, you can change
the `asset_number` for the related zip file. For example, for the map
set of year 2020, the asset number is "11927607".

This function is caching the base map data using `rappdirs::user_data_dir()`.
}
