#' Precision of the Anchor Influences the Amount of Adjustment
#'
#' Data from an experimental study where participants have to guess the price
#' of a plasma tv. There were two experimental conditions.
#' These data were simulated using the sufficient statistics from Janiszewski &
#' Uy (2008).
#'
#' \tabular{lll}{
#'    \strong{price} \tab \code{numeric} \tab Participant z-scores of price\cr
#'    \strong{anchor} \tab \code{factor} \tab Participant anchor\cr
#'    \strong{motivation} \tab \code{factor} \tab motivation to change\cr
#' }
#' @docType data
#' @keywords datasets
#' @name tvprices
#' @usage data(tvprices)
#' @references Janiszewski, C., & Uy, D. (2008). Precision of the anchor influences the amount of adjustment. Psychological Science, 19(2), 121–127. https://doi.org/10.1111/j.1467-9280.2008.02057.x
#' \href{https://doi.org/10.1111/j.1467-9280.2008.02057.x}{
#' DOI:10.1111/j.1467-9280.2008.02057.x}
#' @source \href{https://doi.org/10.1111/j.1467-9280.2008.02057.x}{
#' DOI:10.1111/j.1467-9280.2008.02057.x}
#' @format A data.frame with 59 rows and 3 columns.
NULL
