% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF.cortest.R
\name{cor_test}
\alias{cor_test}
\title{Bayesian correlation analysis}
\usage{
cor_test(..., formula = NULL, iter = 5000, burnin = 3000, nugget.scale = 0.995)
}
\arguments{
\item{...}{matrices (or data frames) of dimensions \emph{n} (observations) by  \emph{p} (variables)
for different groups (in case of multiple matrices or data frames).}

\item{formula}{an object of class \code{\link[stats]{formula}}. This allows for including
control variables in the model (e.g., \code{~ education}).}

\item{iter}{number of iterations from posterior (default is 5000).}

\item{burnin}{number of iterations for burnin (default is 3000).}

\item{nugget.scale}{a scalar which serves to avoid violations of positive definite correlation matrices.
It should be very close to 1 (the default is .995).}
}
\value{
list of class \code{cor_test}:
\itemize{
\item \code{meanF} posterior means of Fisher transform correlations
\item \code{covmF} posterior covariance matrix of Fisher transformed correlations
\item \code{correstimates} posterior estimates of correlation coefficients
\item \code{corrdraws} list of posterior draws of correlation matrices per group
\item \code{corrnames} names of all correlations
}
}
\description{
Estimate the unconstrained posterior for the correlations using a joint uniform prior.
}
\examples{
\donttest{
# Bayesian correlation analysis of the 6 variables in 'memory' object
# we consider a correlation analysis of the first three variable of the memory data.
#fit <- cor_test(BFpack::memory[,1:3])

# Bayesian correlation of variables in memory object in BFpack while controlling
# for the Cat variable
#fit <- cor_test(BFpack::memory[,c(1:4)],formula = ~ Cat)

# Example of Bayesian estimation of polyserial correlations
#memory_example <- memory[,c("Im","Rat")]
#memory_example$Rat <- as.ordered(memory_example$Rat)
#fit <- cor_test(memory_example)

# Bayesian correlation analysis of first three variables in memory data
# for two different groups
#HC <- subset(BFpack::memory[,c(1:3,7)], Group == "HC")[,-4]
#SZ <- subset(BFpack::memory[,c(1:3,7)], Group == "SZ")[,-4]
#fit <- cor_test(HC,SZ)

}
}
