% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.default.R
\name{plot.summary.explore}
\alias{plot.summary.explore}
\title{Plot \code{summary.explore} Objects}
\usage{
\method{plot}{summary.explore}(x, color = "black", size = 2, width = 0, ...)
}
\arguments{
\item{x}{An object of class \code{summary.explore}}

\item{color}{Character string. The color for the error bars.
(defaults to \code{"black"}).}

\item{size}{Numeric. The size for the points (defaults to \code{2}).}

\item{width}{Numeric. The width of error bar ends (defaults to \code{0} ).}

\item{...}{Currently ignored}
}
\value{
A \code{ggplot} object
}
\description{
Visualize the posterior distributions for each partial correlation.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

Y <- ptsd[,1:5]

fit <- explore(Y, iter = 250,
               progress = FALSE)

plt <- plot(summary(fit))

plt
}
}
\seealso{
\code{\link{explore}}
}
