% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar_main.R
\name{logLik.bgvar}
\alias{logLik.bgvar}
\title{Extract Log-Likelihood}
\usage{
\method{logLik}{bgvar}(object, ..., quantile = 0.5)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{quantile}{reported quantiles. Default is set to median.}
}
\value{
Returns an vector of dimension \code{q} (number of specified quantiles) of global log-likelihoods.
}
\description{
Extract Log-Likelihood for \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ng <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100)
logLik(model.ng)
}
}
