% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{resid.corr.test}
\alias{resid.corr.test}
\title{Residual Autocorrelation Test}
\usage{
resid.corr.test(obj, lag.cor=1, alpha=0.95, dig1=5, dig2=3)
}
\arguments{
\item{obj}{An object of class \code{bgvar}.}

\item{lag.cor}{The order of serial correlation to be tested for. Default is set to \code{lag.cor=1}.}

\item{alpha}{Significance level of test. Default is set to \code{alpha=0.95}.}

\item{dig1}{Number of digits to display F-statistics and its critical values.}

\item{dig2}{Number of digits to display p-values.}
}
\value{
Returns a list with the following objects \describe{
\item{\code{Fstat}}{ contains a list of length \code{N} with the associated F-statistic for each variable in each country.}
\item{\code{resTest}}{ contains a matrix of size 2N times K+3, with the F-statistics for each country and each variable.}
\item{\code{p.res}}{ contains a table which summarizes the output.}
\item{\code{pL}}{ contains a list of length \code{N} with the associated p-values for each variable in each country.}
}
}
\description{
An F-test for serial autocorrelation in the residuals.
}
\details{
It is the F-test of the familiar Lagrange Multiplier (LM) statistic (see Godfrey 1978a, 1978b), also known as the 'modified LM' statistic. The null hypothesis is that \eqn{rho}, the autoregressive parameter on the residuals, equals 0 indicating absence of serial autocorrelation. For higher order serial correlation, the null is that all \eqn{rho}'s jointly are 0. The test is implemented as in Vanessa Smith's and Alessandra Galesi's ''GVAR toolbox 2.0 User Guide'', page 129.
}
\examples{
\donttest{
library(BGVAR)
data(testdata)
model.ng <- bgvar(Data=testdata,W=W.test,draws=100,burnin=100)
resid.corr.test(model.ng)
}
}
\references{
Godfrey, L.G. (1978a) \emph{Testing Against General Autoregressive and Moving Average Error Models When the Regressors Include Lagged Dependent Variables.} Econometrica, 46, pp. 1293-1302.
Godfrey, L.G. (1978b) \emph{Testing for Higher Order Serial Correlation in Regression Equations When the Regressors Include Lagged Dependent Variables.} Econometrica, 46, pp. 1303-1310.
Smith, L. V. and A. Galesi (2014) \emph{GVAR Toolbox 2.0 User Guide}, available at \url{https://sites.google.com/site/gvarmodelling/gvar-toolbox}.
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
\author{
Martin Feldkircher
}
