% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_sql}
\alias{BIEN_sql}
\title{Run an SQL query on the BIEN database.}
\usage{
BIEN_sql(query, view_full_occurrence_individual = NULL, agg_traits = NULL,
  species_by_political_division = NULL, bien_species_all = NULL,
  ranges = NULL, bien_taxonomy = NULL, phylogeny = NULL,
  bien_metadata = NULL)
}
\arguments{
\item{query}{A PostgreSQL query.}

\item{view_full_occurrence_individual}{Alternative value to be substituted for "view_full_occurrence_individual" in queries when not NULL.}

\item{agg_traits}{Alternative value to be substituted for "agg_traits" in queries when not NULL.}

\item{species_by_political_division}{Alternative value to be substituted for "species_by_political_division" in queries when not NULL.}

\item{bien_species_all}{Alternative value to be substituted for "bien_species_all" in queries when not NULL.}

\item{ranges}{Alternative value to be substituted for "ranges" in queries when not NULL.}

\item{bien_taxonomy}{Alternative value to be substituted for "bien_taxonomy" in queries when not NULL.}

\item{phylogeny}{Alternative value to be substituted for "phylogeny" in queries when not NULL.}

\item{bien_metadata}{Alternative value to be substituted for "bien_metadata" in queries when not NULL.}
}
\value{
A dataframe returned by the query.
}
\description{
BIEN_sql allows users to supply their own PostgreSQL query.
}
\examples{
\dontrun{
BIEN_sql("SELECT DISTINCT country, scrubbed_species_binomial FROM view_full_occurrence_individual 
WHERE country in ( 'United States' );")}
}

