% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbyfamily}
\alias{BIEN_trait_traitbyfamily}
\title{Download trait data for given families and traits.}
\usage{
BIEN_trait_traitbyfamily(trait, family, print.query = FALSE, ...)
}
\arguments{
\item{trait}{A single trait or a vector of traits.}

\item{family}{A single family or a vector of families.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all data matching the specified trait(s) and family/families.
}
\description{
BIEN_trait_traitbyfamily extracts entries that contain the specified families and trait(s).
}
\examples{
\dontrun{
BIEN_trait_traitbyfamily(trait = "Height", family = "Poaceae")
trait_vector<-c("Height", "Leaf dry mass")
family_vector<-c("Orchidaceae","Poaceae")
BIEN_trait_traitbyfamily(trait=trait_vector,family=family_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_family}},
  \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_species}},
  \code{\link{BIEN_trait_traitbygenus}},
  \code{\link{BIEN_trait_traitbyspecies}},
  \code{\link{BIEN_trait_traits_per_species}},
  \code{\link{BIEN_trait_trait}}
}

