% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_family}
\alias{BIEN_occurrence_family}
\title{Extract species occurrences by family.}
\usage{
BIEN_occurrence_family(family, cultivated = FALSE, only.new.world = TRUE,
  observation.type = FALSE, all.taxonomy = FALSE, native.status = FALSE,
  natives.only = TRUE, political.boundaries = FALSE, collection.info = F,
  ...)
}
\arguments{
\item{family}{A single family or a vector of families.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records for the specified family/families.
}
\description{
BIEN_occurrence_family extracts all occurrences for a given family (or families) from the BIEN database.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php
}
\examples{
\dontrun{
BIEN_occurrence_family("Theaceae")
family_vector<-c("Theaceae","Ericaceae")
BIEN_occurrence_family(family_vector)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_spatialpolygons}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}
