% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_stem_family}
\alias{BIEN_stem_family}
\title{Extract stem data for specified families from BIEN}
\usage{
BIEN_stem_family(
  family,
  cultivated = FALSE,
  only.new.world = FALSE,
  all.taxonomy = FALSE,
  native.status = FALSE,
  natives.only = TRUE,
  political.boundaries = FALSE,
  collection.info = F,
  all.metadata = F,
  ...
)
}
\arguments{
\item{family}{A single family, or a vector of families. Families should be capitalized.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is FALSE}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing stem data for the specified families.
}
\description{
BIEN_stem_family downloads occurrence records for specific families from the BIEN database.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php

Setting either "cultivated" or "native.status" to TRUE will significantly slow the speed of a query.
}
\examples{
\dontrun{
BIEN_stem_family(family = "Marantaceae")
family_vector<-c("Marantaceae", "Buxaceae")
BIEN_stem_family(family = family_vector)
BIEN_stem_family(family = family_vector, all.taxonomy=TRUE, native.status=T)}
}
\seealso{
Other stem functions: 
\code{\link{BIEN_stem_datasource}()},
\code{\link{BIEN_stem_genus}()},
\code{\link{BIEN_stem_sampling_protocol}()},
\code{\link{BIEN_stem_species}()}
}
\concept{stem functions}
