% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_country}
\alias{BIEN_trait_country}
\title{Download trait data for given country.}
\usage{
BIEN_trait_country(
  country,
  trait.name = NULL,
  all.taxonomy = FALSE,
  political.boundaries = TRUE,
  source.citation = F,
  ...
)
}
\arguments{
\item{country}{A single country or a vector of countries.}

\item{trait.name}{Optional.  The trait or traits you want returned.  If left blank, all traits will be returned.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all available trait data for the given country.
}
\description{
BIEN_trait_species extracts trait data for the species country.
}
\examples{
\dontrun{
BIEN_trait_country("South Africa")
BIEN_trait_country(country="South Africa",trait="whole plant growth form")}
}
\seealso{
Other trait functions: 
\code{\link{BIEN_trait_family}()},
\code{\link{BIEN_trait_list}()},
\code{\link{BIEN_trait_mean}()},
\code{\link{BIEN_trait_species}()},
\code{\link{BIEN_trait_traitbyfamily}()},
\code{\link{BIEN_trait_traitbygenus}()},
\code{\link{BIEN_trait_traitbyspecies}()},
\code{\link{BIEN_trait_traits_per_species}()},
\code{\link{BIEN_trait_trait}()}
}
\concept{trait functions}
