% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_family}
\alias{BIEN_trait_family}
\title{Download trait data for given families.}
\usage{
BIEN_trait_family(
  family,
  all.taxonomy = FALSE,
  political.boundaries = FALSE,
  source.citation = F,
  ...
)
}
\arguments{
\item{family}{A single family or a vector of families.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all data matching the specified families.
}
\description{
BIEN_trait_family extracts all trait data for the specified families.
}
\examples{
\dontrun{
BIEN_trait_family("Poaceae")
family_vector<-c("Poaceae","Orchidaceae")
BIEN_trait_family(family_vector)}
}
\seealso{
Other trait functions: 
\code{\link{BIEN_trait_country}()},
\code{\link{BIEN_trait_list}()},
\code{\link{BIEN_trait_mean}()},
\code{\link{BIEN_trait_species}()},
\code{\link{BIEN_trait_traitbyfamily}()},
\code{\link{BIEN_trait_traitbygenus}()},
\code{\link{BIEN_trait_traitbyspecies}()},
\code{\link{BIEN_trait_traits_per_species}()},
\code{\link{BIEN_trait_trait}()}
}
\concept{trait functions}
