\name{ddirimix.grid1D}
\alias{ddirimix.grid1D}
\title{Univariate projection or marginalization of a  Dirichlet mixture density on  on \code{[0,1]}}
\usage{
  ddirimix.grid1D(par = get("dm.expar.D2k4"),
    wei = par$wei, Mu = par$Mu, lnu = par$lnu,
    npoints = 30, eps = 10^(-3), coord = c(1, 2),
    marginal = TRUE, invisible = TRUE, displ = TRUE,
    add = FALSE, ...)
}
\arguments{
  \item{coord}{A vector of size 2: the indices of the
  coordinates upon which the marginalization or projection
  is to be done if the dimension of the sample space is
  greater than two.}

  \item{marginal}{logical. If \code{TRUE}, the angular
  density corresponds to the marginal intensity measure of
  the extreme Poisson process, over coordinates
  \code{coord}. Otherwise, it is only the projection of the
  full dimensional angular measure (hence the moments
  constraints is not satisfied anymore).}

  \item{npoints}{number of points on the 1D discretization
  grid.}

  \item{eps}{the minimum value ( = 1- the maximum value) of
  the grid points.}

  \item{invisible}{Logical: should the result be returned
  as invisible ?}

  \item{displ}{Logical: should a plot be issued ?}

  \item{add}{Logical: should the density be added to the
  currently active plot ?}

  \item{...}{Additional arguments to be passed to
  \code{plot}}

  \item{par}{The parameter list for the Dirichlet mixture
  model.}

  \item{wei}{Optional. If present, overrides the value of
  \code{par$wei}.}

  \item{Mu}{Optional. If present, overrides the value of
  \code{par$Mu}.}

  \item{lnu}{Optional. If present, overrides the value of
  \code{par$lnu}.}
}
\value{
  The discretized density on \code{[eps, 1-eps]} (included
  in [0,1])
}
\description{
  Plots a univariate Dirichlet mixture (in other words, a
  Beta mixture) angular density for extreme bi-variate
  data.
}

