% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_response}
\alias{parse_response}
\title{Parse the results of a call}
\usage{
parse_response(
  response,
  format = NULL,
  clean_dates = TRUE,
  rename = TRUE,
  warn_on_initial_parse = FALSE
)
}
\arguments{
\item{response}{A response object returned from the API request}

\item{format}{character string; NULL to use response service type or "csv" or "xml" to force that format}

\item{clean_dates}{boolean; whether to clean date/time columns}

\item{rename}{boolean; whether to rename column headings (they are usually blank from the API)}

\item{warn_on_initial_parse}{logical; should warning messages be shown during the orignal attempt at parsing the response? The default is FALSE
as many of the data items need further cleaning and so the warning messages from the original attempt to parse the file are uninformative.}
}
\value{
A tibble if format == "csv", otherwise a list
}
\description{
Parse the results of a call
}
\examples{
list_example <- parse_response(
send_request(
build_call("TEMP", api_key = "12345", from_date = "01 Jun 2019",
to_date = "10 Jun 2019", service_type = "xml")
), "xml")
}
