% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_a.R
\name{sampling_a}
\alias{sampling_a}
\title{MCMC sampling of parameter "\eqn{a}" in the \emph{mixdpcluster} model for Bayesian clustering.}
\usage{
sampling_a(
  n = 1,
  a.ini,
  b,
  alpha,
  d_0_a,
  d_1_a,
  mu_star_n_r,
  n.burn = 0,
  n.thin = 0,
  max.time = Inf,
  verbose = F,
  USING_CPP = TRUE
)
}
\arguments{
\item{n}{number of simulations to generate}

\item{a.ini}{initialization value}

\item{b}{parameter \eqn{b} in the posterior distribution of a}

\item{alpha}{parameter \eqn{\alpha} in the posterior distribution of a}

\item{d_0_a}{parameter \eqn{d_0^a} in the posterior distribution of a}

\item{d_1_a}{parameter \eqn{d_1^a} in the posterior distribution of a}

\item{mu_star_n_r}{vector with number of observations allocated to each cluster}

\item{n.burn}{number of iterations in the simulation considered in the burn-in period.}

\item{n.thin}{number of iterations discarded between two simulated values (for thinning of the MCMC chain).}

\item{max.time}{maximum allowed time for the simulation process. The function returns \code{Error} if exceeded.}

\item{verbose}{if \code{T}, the function reports extra information on progress.}

\item{USING_CPP}{indicates usage of C++ in some modules.}
}
\value{
A list with two elements:
\describe{
  \item{$a.chain}{A numeric vector with the simulated values from the posterior distribution of \emph{a}}
  \item{$accept.indic}{A numeric vector with the simulated values from the posterior distribution of \emph{a}}
}
}
\description{
Generates a sample from the posterior distribution of \eqn{a} in the \emph{mixdpcluster} model for bayesian clustering.
  The simulation is done via Metropolis-Hastings method.
}
\references{
Carmona C., Nieto-Barajas L., Canale A. (2017). \emph{Model based approach for household clustering with mixed scale variables.}
}
\keyword{internal}
