% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.oc.comb.R
\name{get.oc.comb}
\alias{get.oc.comb}
\title{Generate operating characteristics for drug combination trials}
\usage{
get.oc.comb(target, p.true, ncohort, cohortsize, n.earlystop=NULL, startdose=c(1, 1),
                   p.saf="default", p.tox="default", cutoff.eli=0.95, extrasafe=FALSE,
                   offset=0.05, ntrial=1000, MTD.contour=FALSE, Nmax=NULL)
}
\arguments{
\item{target}{the target toxicity rate}

\item{p.true}{a \code{J*K} matrix \code{(J<=K)} containing the true toxicity probabilities of
combinations with \code{J} dose levels of agent A and \code{K} dose levels of agent B}

\item{ncohort}{the total number of cohorts}

\item{cohortsize}{the cohort size}

\item{n.earlystop}{the early stopping parameter. If the number of patients treated at the current
dose reaches \code{n.earlystop}, stop the trial or subtrial and select the MTD based on
the observed data. When the waterfall design is used to find the MTD contour,
\code{n.earlystop=12} by default.}

\item{startdose}{the starting dose combination level for drug combination trial}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic (i.e. below the MTD)
such that dose escalation should be undertaken.
The default value is \code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such that deescalation
is required. The default value is \code{p.tox=1.4*target}.}

\item{cutoff.eli}{the cutoff to eliminate an overly toxic dose for safety. We recommend the
default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the stopping
rule is when \code{extrasafe=TRUE}. A larger value leads to a more strict stopping
rule. The default value \code{offset=0.05} generally works well.}

\item{ntrial}{the total number of trials to be simulated}

\item{MTD.contour}{set \code{MTD.contour=TRUE} to select the MTD contour (claiming multiple MTDs).
Otherwise, BOIN design is used to search for a single MTD.}

\item{Nmax}{the maximum number of patients for each subtrial. This argument is effective only when \code{MTD.contour=TRUE}.
            It specifies the maximum number of patients for each subtrial.}
}
\value{
\code{get.oc.comb()} returns the operating characteristics of the BOIN or
waterfall design as a list, including (1) selection percentage at each dose level,
(2) the number of patients treated at each dose level,
(3) the number of toxicities observed at each dose level,
(4) the total correct selection of the MTD,
(5) the total percentage of patients treated at the MTD.
}
\description{
Obtain the operating characteristics of the BOIN design or waterfall design for drug combination
 trials. The BOIN design is to find a MTD, and the waterfall design is to find the MTD contour
 (i.e., multple MTDs in the dose matrix)
}
\details{
The operating characteristics of the BOIN design or waterfall design are generated by
simulating trials under the prespecified true toxicity probabilities of the investigational dose
combinations. The BOIN and waterfall designs have two built-in stopping rules:
(1) stop the trial/subtrial if the lowest dose is eliminated due to toxicity, and no dose should
be selected as the MTD; and (2) stop the trial/subtrial and select the MTD if the number of
patients treated at the current dose reaches \code{n.earlystop}. The first stopping rule is a safety
rule to protect patients from the case in which all doses are overly toxic. The rationale for
the second stopping rule is that when there is a large number (i.e., \code{n.earlystop}) of
patients assigned to a dose, it means that the dose-finding algorithm has approximately converged.
Thus, we can stop the trial/subtrial early and select the MTD to save sample size and reduce the
trial duration.


 For some applications, investigators may prefer a more strict safety stopping rule than rule
 (1) for extra safety when the lowest dose is overly toxic.
 This can be achieved by setting \code{extrasafe=TRUE},
 which imposes the following more strict safety stopping rule:
 stop the trial if (i) the number of patients treated at the lowest dose \code{>=3},
and (ii) Pr(toxicity rate of the lowest dose > \code{target} | data) > \code{cutoff.eli-offset}.
As a tradeoff, the strong stopping rule will decrease the MTD selection percentage
 when the lowest dose actually is the MTD.
}
\note{
We should avoid setting the values of \code{p.saf} and \code{p.tox} very close to the target.
This is because the small sample sizes of typical phase I trials prevent us from differentiating
 the target toxicity rate from the rates close to it. In addition, in most clinical applications,
 the target toxicity rate is often a rough guess, and finding a dose level with a toxicity rate
 reasonably close to the target rate will still be of interest to the investigator. The default
 values provided by \code{get.oc.comb()} are generally reasonable for most clinical applications.
}
\examples{
p.true<-matrix(c(0.01,0.03,0.15,0.20,0.30,
                 0.03,0.05,0.10,0.30,0.60,
                 0.08,0.10,0.30,0.60,0.75), byrow=TRUE, ncol=5)
## find the MTD contour using waterfall design
get.oc.comb(target=0.3, p.true, ncohort=20, cohortsize=3, n.earlystop=12, startdose=c(1,1),
  		       ntrial=10, MTD.contour=TRUE)

## find a single MTD using BOIN design
get.oc.comb(target=0.3, p.true, ncohort=20, cohortsize=3, n.earlystop=12, startdose=c(1,1),
			       ntrial=10, MTD.contour=FALSE)
}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
            Trials, Journal of the Royal Statistical Society: Series C, 64, 507-523.

           Lin R. and Yin, G. (2016). Bayesian Optimal Interval Designs for Dose Finding in
           Drug-combination Trials, Statistical Methods in Medical Research, to appear.

           Zhang L. and Yuan, Y. (2016). A Simple Bayesian Design to Identify the Maximum
           Tolerated Dose Contour for Drug Combination Trials, under review.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.2_tutorial.pdf}

          Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

