% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boss.R
\name{coef.boss}
\alias{coef.boss}
\title{Select coefficient vector(s) for BOSS.}
\usage{
\method{coef}{boss}(object, ic = c("aicc", "bicc", "aic", "bic", "gcv",
  "cp"), select.boss = NULL, ...)
}
\arguments{
\item{object}{The boss object, returned from calling the \code{boss} function.}

\item{ic}{Which information criterion is used to select the optimal coefficient vector for BOSS.
The default is AICc-hdf.}

\item{select.boss}{The index (or indicies) of columns in the coefficient matrix for which
one wants to select. By default (NULL) it's selected by the information criterion specified in
'ic'.}

\item{...}{Extra arguments (unused for now)}
}
\value{
The chosen coefficient vector(s) for BOSS.
}
\description{
This function returns the optimal coefficient vector of BOSS selected by AICc
(by default) or other types of information criterion.
}
\details{
If \code{select.boss} is specified, the function returns
corresponding column(s) in the coefficient matrix.

If \code{select.boss} is unspecified, the function returns the optimal coefficient
vector selected by AICc-hdf (other choice of IC can be specified in the argument \code{ic}).
The only exception is when n>=p, where hdf is not well defined, and the entire coefficient matrix
is returned.
}
\examples{
## Generate a trivial dataset, X has mean 0 and norm 1, y has mean 0
set.seed(11)
n = 20
p = 5
x = matrix(rnorm(n*p), nrow=n, ncol=p)
x = scale(x, center = colMeans(x))
x = scale(x, scale = sqrt(colSums(x^2)))
beta = c(1, 1, 0, 0, 0)
y = x\%*\%beta + scale(rnorm(n, sd=0.01), center = TRUE, scale = FALSE)

## Fit the model
boss_result = boss(x, y)

## Get the coefficient vector selected by AICc-hdf (S3 method for boss)
beta_boss_aicc = coef(boss_result)
# the above is equivalent to the following
beta_boss_aicc = boss_result$beta_boss[, which.min(boss_result$IC_boss$aicc), drop=FALSE]
## Get the fitted values of BOSS-AICc-hdf (S3 method for boss)
mu_boss_aicc = predict(boss_result, newx=x)
# the above is equivalent to the following
mu_boss_aicc = cbind(1,x) \%*\% beta_boss_aicc

## Repeat the above process, but using Cp-hdf instead of AICc-hdf
## coefficient vector
beta_boss_cp = coef(boss_result, method.boss='cp')
beta_boss_cp = boss_result$beta_boss[, which.min(boss_result$IC_boss$cp), drop=FALSE]
## fitted values of BOSS-Cp-hdf
mu_boss_cp = predict(boss_result, newx=x, method.boss='cp')
mu_boss_cp = cbind(1,x) \%*\% beta_boss_cp
}
