% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{run_mcmc}
\alias{run_mcmc}
\title{Run the BSBT MCMC algorithm}
\usage{
run_mcmc(
  n.iter,
  delta,
  covariance.matrix,
  win.matrix,
  f.initial,
  alpha = FALSE,
  omega = 0.1,
  chi = 0.1
)
}
\arguments{
\item{n.iter}{The number of iterations to be run}

\item{delta}{The underrlaxed tuning parameter must be in (0, 1)}

\item{covariance.matrix}{The output from the covariance matrix function, which contains the decomposed and inverted covariance matrix.}

\item{win.matrix}{A matrix, where w_ij give the number of times object i beat j}

\item{f.initial}{A vector of the initial estimate for f}

\item{alpha}{A boolean if inference for alpha should be carried out. If this is TRUE, the covariance matrix}

\item{omega}{The value of the inverse gamma shape parameter}

\item{chi}{The value of the inverse gamma scale parameter}
}
\value{
A list of MCMC output
\itemize{
\item f.matrix - A matrix containing the each iteration of f
\item alpha.sq - A vector containing the iterations of alpha^2
\item acceptance.rate - The acceptance rate for f
\item time.taken - Time taken to run the MCMC algorithm in seconds
}
}
\description{
This function runs the BSBT MCMC algorithm to estimate the deprivation parameters. In this version, the judges are assumed to act homogeneously. This algorithm estimates the deprivation in each object and the prior distribution variance parameter. For data with two types of judges, see \code{\link{run_symmetric_mcmc}}.
}
\examples{

n.iter <- 10
delta <- 0.1
covariance.matrix <- list()
covariance.matrix$mean <- c(0, 0, 0)
covariance.matrix$decomp <- diag(3)
covariance.matrix$inv    <- diag(3)
comparisons <- data.frame("winner" = c(1, 3, 2, 2), "loser" = c(3, 1, 1, 3))
win.matrix <- comparisons_to_matrix(3, comparisons) #construct covariance matrix
f.initial <- c(0, 0, 0) #initial estimates for lamabda_1, lambda_2, lambda_3

mcmc.output <- run_mcmc(n.iter, delta, covariance.matrix, win.matrix, f.initial)


}
