% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Domestic}
\alias{Domestic}
\title{Rates of domestic violence per 1,000 women by age groups}
\format{A data frame/tibble with five observations on two variables
\describe{ 
\item{age}{a factor with levels \code{12-19}, \code{20-24},
\code{25-34}, \code{35-49}, and \code{50-64}} 
\item{rate}{rate of domestic violence per 1000 women} 
}}
\source{
U.S. Department of Justice.
}
\usage{
Domestic
}
\description{
Data for Exercise 1.20
}
\examples{

barplot(Domestic$rate, names.arg = Domestic$age)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Domestic, aes(x = age, y = rate)) + 
           geom_bar(stat = "identity", fill = "purple", color = "black") + 
           labs(x = "", y = "Domestic violence per 1000 women") + 
           theme_bw()
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
