% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Statelaw}
\alias{Statelaw}
\title{Operating expenditures per resident for each of the state law enforcement
agencies}
\format{A data frame/tibble with 50 observations on two variables
\describe{ 
\item{state}{U.S. state} 
\item{cost}{dollars spent per resident on law enforcement} 
}}
\source{
Bureau of Justice Statistics, \emph{Law Enforcement Management and 
Administrative Statistics, 1993}, NCJ-148825, September 1995, page 84.
}
\usage{
Statelaw
}
\description{
Data for Exercise 6.62
}
\examples{

EDA(Statelaw$cost)
SIGN.test(Statelaw$cost, md = 8, alternative = "less")

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
