% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_model.R
\name{gen_two_rmodel}
\alias{gen_two_rmodel}
\title{Generate two random Boolean models with a specified number of steps apart}
\usage{
gen_two_rmodel(var, steps, mvar = length(var), and_bool, in_bmodel = NULL,
  self_loop = F)
}
\arguments{
\item{var}{character vector. A vector of single genes/variables to be used in the model.}

\item{steps}{integer. Number of steps apart between the two models. If steps=0, give completely random starting model.}

\item{mvar}{integer. Maximum number of variables in act or inh rule. Default to length(var).}

\item{and_bool}{logical. Indicates whether to include AND terms or not.}

\item{in_bmodel}{BoolModel object. The starting model supplied.}

\item{self_loop}{logical. Indicates whether to allow self_loop. Default to F.}
}
\description{
This function generates a random Boolean model, then get another random Boolean model that is a specified number of steps apart by adding and/or removing genes. 
Returns a list of two S4 BoolModel objects.
}
\details{
The number of terms in a function for a gene is modelled by power-law distribution.
}

