% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgbb.R
\name{bgbb.rf.matrix.PosteriorMeanDropoutRate}
\alias{bgbb.rf.matrix.PosteriorMeanDropoutRate}
\title{BG/BB Posterior Mean Dropout Rate using a recency-frequency matrix}
\usage{
bgbb.rf.matrix.PosteriorMeanDropoutRate(params, rf.matrix)
}
\arguments{
\item{params}{BG/BB parameters - a vector with alpha, beta, gamma, and delta,
in that order. Alpha and beta are unobserved parameters for the
beta-Bernoulli transaction process. Gamma and delta are unobserved
parameters for the beta-geometric dropout process.}

\item{rf.matrix}{recency-frequency matrix. It must contain columns for
frequency ("x"), recency ("t.x"), number of transaction opportunities in
the calibration period ("n.cal"), and the number of customers with this
combination of recency, frequency and transaction opportunities in the
calibration period ("custs"). Note that recency must be the time between
the start of the calibration period and the customer's last transaction,
not the time between the customer's last transaction and the end of the
calibration period.}
}
\value{
The posterior mean dropout rate.
}
\description{
Computes the mean value of the marginal posterior value of Theta, the geometric dropout process parameter.
}
\details{
E(Theta | alpha, beta, gamma, delta, x, t.x, n). This is calculated by setting \code{l = 0} and \code{m = 1} in \code{\link{bgbb.PosteriorMeanLmProductMoment}}.

\code{rf.matrix} has columns x\verb{, }t.x\verb{, and }n.cal`.
}
\examples{
data(donationsSummary)

rf.matrix <- donationsSummary$rf.matrix
# donationsSummary$rf.matrix already has appropriate column names

# starting-point parameters
startingparams <- c(1, 1, 0.5, 3)
# estimated parameters
est.params <- bgbb.EstimateParameters(rf.matrix, startingparams)

# return the posterior mean dropout rate vector
bgbb.rf.matrix.PosteriorMeanDropoutRate(est.params, rf.matrix)
}
\references{
Fader, Peter S., Bruce G.S. Hardie, and Jen Shang.
"Customer-Base Analysis in a Discrete-Time Noncontractual Setting."
\emph{Marketing Science} 29(6), pp. 1086-1108. 2010. INFORMS.
\href{http://www.brucehardie.com/papers/020/}{Web.}
}
\seealso{
\code{\link{bgbb.PosteriorMeanDropoutRate}}
}
