% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/96_summary.R
\name{summary.bvar}
\alias{summary.bvar}
\alias{print.bvar_summary}
\title{Summary method for Bayesian VARs}
\usage{
\method{summary}{bvar}(object, ...)

\method{print}{bvar_summary}(x, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{...}{Not used.}

\item{x}{A \code{bvar_summary} object.}
}
\value{
Returns a list of class \code{bvar_summary} with elements that can
can be accessed individually:
\itemize{
  \item \code{bvar} - \emph{object}, the \code{bvar} object provided.
  \item \code{coef} - Coefficient values from \code{\link{coef.bvar}}.
  \item \code{vcov} - VCOV values from \code{\link{vcov.bvar}}.
  \item \code{logLik} - The Log-Likelihood from \code{\link{logLik.bvar}}.
}
}
\description{
Retrieves several outputs of interest, including the median coefficient
matrix, the median variance-covariance matrix, and the Log-Likelihood. For
IRFs and forecasts separate methods for summarizing exist.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)
summary(x)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{coef.bvar}};
\code{\link{logLik.bvar}}
}
