% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.Merton-method}
\alias{predict,est.Merton-method}
\title{Prediction for a jump diffusion process}
\usage{
\S4method{predict}{est.Merton}(object, t, burnIn, thinning, Lambda.mat,
  which.series = c("new", "current"), M2pred = 10, only.interval = TRUE,
  level = 0.05, cand.length = 1000, pred.alg = c("Distribution",
  "Trajectory", "simpleTrajectory", "simpleBayesTrajectory"), sample.length,
  plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.Merton", created with method \code{\link{estimate,Merton-method}}}

\item{t}{vector of time points to make predictions for}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{Lambda.mat}{matrix-wise definition of intensity rate function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{only.interval}{if TRUE: only calculation of prediction intervals (only for pred.alg = "Distribution")}

\item{level}{level of the prediction intervals}

\item{cand.length}{length of candidate samples (if method = "vector"), for jump diffusion}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleBayesTrajectory"}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of a stochastic process
  \eqn{Y_t = y_0 \exp( \phi t - \gamma2/2 t+\gamma W_t + \log(1+\theta) N_t)}.
}
\examples{
cl <- set.to.class("Merton",
               parameter = list(thetaT = 0.1, phi = 0.05, gamma2 = 0.1, xi = c(3, 1/4)),
               Lambda = function(t, xi) (t/xi[2])^xi[1])
t <- seq(0, 1, by = 0.01)
data <- simulate(cl, t = t, y0 = 0.5)
est <- estimate(cl, t, data, 1000)
plot(est)
\dontrun{
pred1 <- predict(est, Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1])
pred2 <- predict(est, Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1], pred.alg = "Trajectory")
pred3 <- predict(est, pred.alg = "simpleTrajectory")
pred4 <- predict(est, pred.alg = "simpleBayesTrajectory")
}
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

